#include <iostream>
#include <gtk/gtkspinbutton.h>
#include "gtkedint.h"

static void on_changed(GtkEditable     *editable,
		       GtkEdInt *editor) {
    editor->signal_changed();
}

void GtkEdInt::setAttribute(EditableAttribute *attrib) {
    if (widget ==0 ) {
	std::cerr << "setAttribute MUST be called after build()" << std::endl;
	throw -1;
    }
    attribute=dynamic_cast<EdInt*>(attrib);
    if (!attribute.valid()) {
	std::cerr << "GtkEdFloat::build: FATAL ERROR: argument isn't an EdFloat" << std::endl;
        throw -1;
    }
    if (handler_id != 0xFFFFFFFF) {
	g_signal_handler_disconnect((gpointer) widget, handler_id);
    }
    gtk_spin_button_set_range(GTK_SPIN_BUTTON(widget), (gdouble)attribute->getMin(), (gdouble)attribute->getMax());
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget), (gdouble)attribute->get());
    handler_id = g_signal_connect ((gpointer) widget, "changed",
				   G_CALLBACK (on_changed),
				   this);
}

void GtkEdInt::build() {
    GtkObject *widget_adj = gtk_adjustment_new (0,
				     0,
				     0, 1, 10, 10);
    widget = gtk_spin_button_new (GTK_ADJUSTMENT (widget_adj), 1, 0);

    gtk_widget_ref(widget);
}

GtkEdInt::GtkEdInt() {
    widget=0;
    widget_adj=0;
    handler_id=0xFFFFFFFF;
}

GtkEdInt::~GtkEdInt() {
    if (handler_id != 0xFFFFFFFF) {
        g_signal_handler_disconnect((gpointer) widget, handler_id);
    }
    if (widget!=0) gtk_widget_unref(widget);
}

void GtkEdInt::signal_changed() {
    attribute->set((int)gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget)));
}
