#ifndef __GTK_ED_FACTORY_H__
#define __GTK_ED_FACTORY_H__

#include <map>
#include "gtkedattribute.h"

/** @class GtkEdFactory
 * @brief GTK Editors factory
 * This class has the adequate editor widget for each editable attribute type.
 * Allows to register editors for attribute types and finding editors for
 * attribute types.
 */
class GtkEdFactory {
public:
    /**
     * Registers an editor for editable attribute type. 
     */
    void registerEditor(std::string attribute_type, GtkEdAttribute *ed);

    /**
     * Finds an editor suitable for one attribute. This method finds the
     * editor that was previously registered for the type of this attribute.
     * This method returns a clone of the sample registered, so, remember to
     * keep a reference to it.
     */
    GtkEdAttribute *find(EditableAttribute *attr);

    /**
     * Finds an editor suitable for one attribute. This method finds the
     * editor that was previously registered for the type given.
     * This method returns a clone of the sample registered, so, remember to
     * keep a reference to it.
     */
    GtkEdAttribute *find(std::string attribute_type);

    /** Singleton pattern */
    static GtkEdFactory *instance() { return _instance; }
private:
    static GtkEdFactory *_instance;
    typedef std::map< std::string, osg::ref_ptr<GtkEdAttribute> > EditorMap;
    EditorMap editors;
};

#endif
