#include <iostream>
#include "gtkedfactory.h"

GtkEdFactory *GtkEdFactory::_instance = new GtkEdFactory();

void GtkEdFactory::registerEditor(std::string attribute_type,
				  GtkEdAttribute *ed) {
    if (editors.find(attribute_type) != editors.end()) {
	std::cerr << "GtkEdFactory::registerEditor: WARNING! The editable " << attribute_type << " already has an editor registered" << std::endl;
        return;
    }
    editors[attribute_type] = ed;
}

GtkEdAttribute *GtkEdFactory::find(EditableAttribute *attr) {
    std::string type = attr->getType();
    return find(type);
}

GtkEdAttribute *GtkEdFactory::find(std::string type) {
    if (editors.find(type) != editors.end()) {
        return editors[type]->clone();
    } else {
	std::cerr << "GtkEdFactory::find: ERROR! There are no editors for type " << type << std::endl;
        throw -1;
    }
}
