#include <iostream>
#include <gtk/gtkoptionmenu.h>
#include <gtk/gtkmenu.h>
#include <gtk/gtkmenuitem.h>
#include "gtkedenum.h"

static void
on_optionmenu_changed                 (GtkOptionMenu   *optionmenu,
				       GtkEdEnum *editor)
{
    editor->signal_changed();
}

void GtkEdEnum::setAttribute(EditableAttribute *attrib) {
    attribute=dynamic_cast<EdEnum*>(attrib);
    if (!attribute.valid()) {
	std::cerr << "GtkEdEnum::build: FATAL ERROR: argument isn't an EdEnum" << std::endl;
        throw -1;
    }
    if (widget ==0 ) {
	std::cerr << "setAttribute MUST be called after build()" << std::endl;
	throw -1;
    }
    if (handler_id != 0xFFFFFFFF) {
	g_signal_handler_disconnect((gpointer) widget, handler_id);
    }
    GtkWidget *menu = gtk_menu_new();
    for (unsigned i=0; i<attribute->getNumOptions();i++) {
	std::string option = attribute->getOption(i);
	GtkWidget *item = gtk_menu_item_new_with_mnemonic (option.c_str());
	gtk_container_add (GTK_CONTAINER (menu), item);
    }
    gtk_option_menu_set_menu (GTK_OPTION_MENU (widget), menu);

    gtk_option_menu_set_history(GTK_OPTION_MENU (widget), attribute->getValueIndex());
    handler_id=g_signal_connect ((gpointer) widget, "changed",
				 G_CALLBACK (on_optionmenu_changed),
				 this);
}

void GtkEdEnum::build() {
    widget=gtk_option_menu_new();

    gtk_widget_ref(widget);
}

GtkEdEnum::GtkEdEnum() {
    widget=0;
    handler_id=0xFFFFFFFF;
}

GtkEdEnum::~GtkEdEnum() {
    if (widget!=0) gtk_widget_unref(widget);
}

void GtkEdEnum::signal_changed() {
    attribute->set(gtk_option_menu_get_history(GTK_OPTION_MENU(widget)));
}
