#include <iostream>
#include <gtk/gtkframe.h>
#include <gtk/gtktable.h>
#include <gtk/gtkspinbutton.h>
#include <gtk/gtklabel.h>
#include "gtkedcolour.h"

static void on_adjustmentR_changed (GtkAdjustment *adjustment,
				   GtkEdColour *editor) {
    editor->signal_changed(0);
}
static void on_adjustmentG_changed (GtkAdjustment *adjustment,
				   GtkEdColour *editor) {
    editor->signal_changed(1);
}
static void on_adjustmentB_changed (GtkAdjustment *adjustment,
				   GtkEdColour *editor) {
    editor->signal_changed(2);
}
static void on_adjustmentA_changed (GtkAdjustment *adjustment,
				   GtkEdColour *editor) {
    editor->signal_changed(3);
}

void GtkEdColour::setAttribute(EditableAttribute *attrib) {
    static void* handlers[4]={
	(void*)on_adjustmentR_changed,
	(void*)on_adjustmentG_changed,
	(void*)on_adjustmentB_changed,
	(void*)on_adjustmentA_changed
    };
    attribute=dynamic_cast<EdColour*>(attrib);
    if (attribute == 0) {
	std::cerr << "GtkEdColour::build: FATAL ERROR: argument isn't an EdColour" << std::endl;
        throw -1;
    }
    if (widget ==0 ) {
	std::cerr << "setAttribute MUST be called after build()" << std::endl;
	throw -1;
    }
    if (handler_assigned) {
	for (unsigned i=0;i<4;i++) {
	    g_signal_handler_disconnect((gpointer) spin[i], handler_id[i]);
	}
    }
    for (unsigned i=0;i<4;i++) {
	//gtk_adjustment_set_value(GTK_ADJUSTMENT(widget_adj[i]),attribute->get()[i]);
        gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin[i]), (gdouble)attribute->get()[i]);
	handler_id[i] = g_signal_connect ((gpointer) spin[i], "changed",
					  G_CALLBACK (handlers[i]),
					  this);
    }
    handler_assigned=true;
    gtk_frame_set_label (GTK_FRAME (widget), attrib->getName().c_str());
}


void GtkEdColour::build() {
    static char* labels[4]={
	"R:",
	"G:",
	"B:",
	"A:"
    };

    widget = gtk_frame_new (NULL);
    GtkWidget *table = gtk_table_new (4, 2, FALSE);
    gtk_container_set_border_width (GTK_CONTAINER (table), 5);
    gtk_container_add(GTK_CONTAINER(widget), table);
    for (unsigned i=0;i<4;i++) {
	GtkWidget *label = gtk_label_new (labels[i]);
	gtk_table_attach (GTK_TABLE (table), label, 0, 1, i, i+1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 5);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	GtkObject *widget_adj = gtk_adjustment_new (0,
						    0,
						    1, 0.01, 0.1, 0.1);
	spin[i] = gtk_spin_button_new (GTK_ADJUSTMENT (widget_adj), 1, 4);
	gtk_table_attach (GTK_TABLE (table), spin[i], 1, 2, i, i+1,
			  (GtkAttachOptions) (GTK_FILL),
			  (GtkAttachOptions) (0), 5, 5);
    }
    gtk_widget_ref(widget);
}

GtkEdColour::GtkEdColour() {
    widget=0;
    handler_assigned=false;
}

GtkEdColour::~GtkEdColour() {
    if (widget!=0) gtk_widget_unref(widget);
}

void GtkEdColour::signal_changed(int i) {
    osg::Vec4 v = attribute->get();
    GtkAdjustment *widget_adj=gtk_spin_button_get_adjustment(GTK_SPIN_BUTTON(spin[i]));
    v[i]=gtk_adjustment_get_value(GTK_ADJUSTMENT(widget_adj));
    attribute->set(v);
}
