#include <iostream>
#include <gtk/gtkcheckbutton.h>
#include "gtkedbool.h"

static void
on_widget_toggled                (GtkToggleButton *togglebutton,
				  GtkEdBool *ed)
{
    ed->signal_toggled();
}

void GtkEdBool::setAttribute(EditableAttribute *attrib) {
    attribute=dynamic_cast<EdBool*>(attrib);
    if (!attribute.valid()) {
	std::cerr << "GtkEdBool::build: FATAL ERROR: argument isn't an EdBool" << std::endl;
        throw -1;
    }
    if (widget ==0 ) {
	std::cerr << "setAttribute MUST be called after build()" << std::endl;
	throw -1;
    }
    if (handler_id != 0xFFFFFFFF) {
        g_signal_handler_disconnect((gpointer) widget, handler_id);
    }
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(widget), attribute->get());
    handler_id=g_signal_connect ((gpointer) widget, "toggled",
		      G_CALLBACK (on_widget_toggled),
		      this);
}


void GtkEdBool::build() {
    widget=gtk_check_button_new();
    gtk_widget_ref(widget);
}

GtkEdBool::GtkEdBool() {
    widget=0;
    handler_id=0xFFFFFFFF;
}

GtkEdBool::~GtkEdBool() {
    if (widget!=0) gtk_widget_unref(widget);
}

void GtkEdBool::signal_toggled() {
    attribute->toggle();
}
