#ifndef __GTK_ED_ATTRIBUTE_H__
#define __GTK_ED_ATTRIBUTE_H__

#include <editable/editableattribute.h>
#include "gtkwidgetwrap.h"

/** @class GtkEdAttribute
 * @brief GTK Editor for attributes.
 * This class defines an interface that must follow all the GTK attribute
 * editors.
 * It's implementing the prototype pattern. So the constructor shouldn't do
 * anything if possible. The interface must be built in the 'build' method.
 */
class GtkEdAttribute: public GtkWidgetWrap {
public:
    /**
     * Set up the editor for editing one attribute. This method allows for
     * "persistent" editors that edit different attributes over the time.
     * It's highly recommended to check the type of the attribute with
     * dynamic_cast to ensure that is the type of attribute that the concrete
     * editor can handle. The attribute could be null, meaning that this
     * editor isn't editing anything, and in such case, you should disable
     * the editor. This method must be called *ALWAYS* after build(), never
     * before.
     */
    virtual void setAttribute(EditableAttribute *attrib)=0;

    /**
     * Build the interface for editing the concrete attribute type.
     * It's detached from the constructor to allow static editors (they
     * aren't used right now, but who knows) as GTK and other libs need
     * to initialize before creating any widget. Take into account that
     * this editor won't have any attribute associated at the beginning so
     * the editor should be disabled to notice the user that
     * there isn't anything to edit.
     */
    virtual void build()=0;

    /**
     * Prototype pattern. This method instantiates a new editor of the same
     * type of the called editor. This way, we can register lots of generic
     * editors in the factory for each type of attribute and later get
     * instancies of them without knowing the concrete class :-)
     */
    virtual GtkEdAttribute *clone()=0;

    /**
     * By default, the form will put itself the labels for all the editors
     * in a column and the editors in other column, all aligned. But if the
     * concrete editor is very complex and must handle itself labeling (like
     * list editors) then reimplement this method returning false
     *
     * Labels are used to put in the GUI the name of the editable component
     * to ease the understanding of the editable meaning
     */
    virtual bool needsLabel() { return true; }
};

typedef std::vector< osg::ref_ptr<GtkEdAttribute> > EditorList;


#endif
