#include <config.h>

#ifdef HAVE_GNOME

#include <iostream>
#include <libgnomeui/gnome-file-entry.h>
#include <gtk/gtkentry.h>
#include "gnomeedfile.h"

static void on_changed(GtkEditable     *editable,
		       GnomeEdFile *editor) {
    editor->signal_changed();
}

void GnomeEdFile::setAttribute(EditableAttribute *attrib) {
    if (widget ==0 ) {
	std::cerr << "setAttribute MUST be called after build()" << std::endl;
	throw -1;
    }
    attribute = dynamic_cast<EdFile*>(attrib);
    if (!attribute.valid()) {
	std::cerr << "GnomeEdFile::build: FATAL ERROR: argument isn't an EdString" << std::endl;
        throw -1;
    }
    if (handler_id != 0xFFFFFFFF) {
        g_signal_handler_disconnect((gpointer) widget, handler_id);
    }
    gtk_entry_set_text(GTK_ENTRY(gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(widget))),attribute->get().c_str());
    gnome_file_entry_set_title (GNOME_FILE_ENTRY (widget), attrib->getName().c_str());
    handler_id = g_signal_connect (GTK_OBJECT(gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(widget))),
				   "changed",
				   G_CALLBACK (on_changed),
				   this);
}

void GnomeEdFile::build() {
    widget = gnome_file_entry_new (NULL, NULL);

    gtk_widget_ref(widget);
}

GnomeEdFile::GnomeEdFile() {
    widget=0;
    handler_id=0xFFFFFFFF;
}

GnomeEdFile::~GnomeEdFile() {
    if (handler_id != 0xFFFFFFFF) {
        g_signal_handler_disconnect((gpointer) widget, handler_id);
    }
    if (widget!=0) gtk_widget_unref(widget);
}

void GnomeEdFile::signal_changed() {
    if (attribute.valid()) {
	attribute->set(gtk_entry_get_text(GTK_ENTRY(gnome_file_entry_gtk_entry(GNOME_FILE_ENTRY(widget)))));
    }
}

#endif
