#include <config.h>

#ifdef HAVE_GNOME

#include <iostream>
#include <libgnomeui/gnome-color-picker.h>
#include "gnomeedcolour.h"

void
on_colorpicker1_color_set              (GnomeColorPicker *colorpicker,
                                        guint            red,
                                        guint            green,
                                        guint            blue,
                                        guint            alpha,
                                        GnomeEdColour *ed)
{
    ed->signal_changed();
}


void GnomeEdColour::setAttribute(EditableAttribute *attrib) {
    attribute=dynamic_cast<EdColour*>(attrib);
    if (attribute == 0) {
	std::cerr << "GnomeEdColour::build: FATAL ERROR: argument isn't an EdColour" << std::endl;
        throw -1;
    }
    if (widget ==0 ) {
	std::cerr << "setAttribute MUST be called after build()" << std::endl;
	throw -1;
    }
    if (handler_assigned) {
	g_signal_handler_disconnect((gpointer) widget, handler_id);
    }
    osg::Vec4 color = attribute->get();
    gnome_color_picker_set_d(GNOME_COLOR_PICKER(widget), (gdouble)color[0],(gdouble)color[1],(gdouble)color[2],(gdouble)color[3]);
    handler_id = g_signal_connect ((gpointer) widget, "color_set",
				   G_CALLBACK (on_colorpicker1_color_set),
				   this);
    handler_assigned=true;
}


void GnomeEdColour::build() {
    widget = gnome_color_picker_new ();
    gnome_color_picker_set_use_alpha(GNOME_COLOR_PICKER(widget), TRUE);
    gtk_widget_ref(widget);
}

GnomeEdColour::GnomeEdColour() {
    widget=0;
    handler_assigned=false;
}

GnomeEdColour::~GnomeEdColour() {
    if (widget!=0) gtk_widget_unref(widget);
}

void GnomeEdColour::signal_changed() {
    gdouble r,g,b,a;
    gnome_color_picker_get_d(GNOME_COLOR_PICKER(widget),&r,&g,&b,&a);
    attribute->set(osg::Vec4(r,g,b,a));
}

#endif
