#ifndef __ENTITY_FACTORY_H__
#define __ENTITY_FACTORY_H__

#include <osg/Object>
#include <editable/editableentity.h>
#include <map>

/** @class EntityFactory
 * @brief Maps osg::Object's to EditableEntity's
 */
class EntityFactory {
public:
    void registerEntity(osg::Object *object, EditableEntity *entity);

    /// Finds a wrapper around the given object. It also establishes the
    /// object in the wrapper
    EditableEntity *findEntity(osg::Object *object);

    /// Singleton pattern
    static EntityFactory *instance() { return _instance; }
private:
    EntityFactory();
    /// Singleton
    static EntityFactory *_instance;

    std::map<std::string, osg::ref_ptr<EditableEntity> > mapping;
};



#endif
