#include "entityfactory.h"

EntityFactory *EntityFactory::_instance=new EntityFactory();

EntityFactory::EntityFactory() {}

void EntityFactory::registerEntity(osg::Object *object, EditableEntity *entity) {
    mapping[object->className()]=entity;
}

EditableEntity *EntityFactory::findEntity(osg::Object *object) {
    std::string name=object->className();
    if (mapping.find(name) != mapping.end()) {
	EditableEntity *ed = mapping[name]->clone();
        ed->setObject(object);
	return ed;
    } else {
        return 0;
    }
}
