#ifndef __EdTexture_H__
#define __EdTexture_H__

#include <config.h>
#include <osg/Texture2D>
#include <editable/editableentity.h>
#include <editable/attributes/all.h>
#include <local.h>

class EdTexture: public EditableEntity {
public:
    EdTexture();
    EdTexture(osg::Texture *);
    virtual void setObject(osg::Object *object);
    virtual void commit();
    virtual EditableAttributeList getAttributes() { return list; }
    inline virtual std::string getName() const { return _("Texture"); }
    inline virtual EditableEntity *clone() { return new EdTexture(); }
    inline virtual void genObject() { setObject(new osg::Texture2D()); }
    virtual osg::Object *getObject() { return model.get(); }
private:
    osg::ref_ptr< osg::Texture2D > model;
    EditableAttributeList list;
    //Attributes
    osg::ref_ptr< EdFile > image_file;
    osg::ref_ptr< EdEnum > wrap_s;
    osg::ref_ptr< EdEnum > wrap_t;
    osg::ref_ptr< EdEnum > wrap_r;
    osg::ref_ptr< EdColour > border_color;
    osg::ref_ptr< EdEnum > min_filter;
    osg::ref_ptr< EdEnum > mag_filter;
};
#endif //__EdTexture_H__
