#include "edtexture.h"

#include <command/comtexture.h>


void EdTexture::setObject(osg::Object *object) {
    model=dynamic_cast<osg::Texture2D *> (object);
    if (model == 0) {
	std::cerr << "EdTexture::setObject(): FATAL ERROR: This is not an 'osg::Texture'" << std::endl;
        throw -1;
    }
    std::string texname="";
    if (model->getImage()) {
        texname=model->getImage()->getFileName();
    }
    image_file = new EdFile( _("Image file"), _("Name of file where the image is"), texname );
    
    list.push_back(image_file.get());
    wrap_s = new EdEnum( _("Wrap S"), _("What to do if texture coordinates are bigger than image") );
    wrap_s->addOption(_("Clamp"),osg::Texture::CLAMP);
    wrap_s->addOption(_("Clamp to edge"),osg::Texture::CLAMP_TO_EDGE);
    wrap_s->addOption(_("Clamp to border"),osg::Texture::CLAMP_TO_BORDER);
    wrap_s->addOption(_("Repeat"),osg::Texture::REPEAT);
    wrap_s->addOption(_("Mirror"),osg::Texture::MIRROR);
    wrap_s->setInitial(model->getWrap(osg::Texture::WRAP_S));
    
    list.push_back(wrap_s.get());
    wrap_t = new EdEnum( _("Wrap T"), _("What to do if texture coordinates are bigger than image") );
    wrap_t->addOption(_("Clamp"),osg::Texture::CLAMP);
    wrap_t->addOption(_("Clamp to edge"),osg::Texture::CLAMP_TO_EDGE);
    wrap_t->addOption(_("Clamp to border"),osg::Texture::CLAMP_TO_BORDER);
    wrap_t->addOption(_("Repeat"),osg::Texture::REPEAT);
    wrap_t->addOption(_("Mirror"),osg::Texture::MIRROR);
    wrap_t->setInitial(model->getWrap(osg::Texture::WRAP_T));
    
    list.push_back(wrap_t.get());
    wrap_r = new EdEnum( _("Wrap R"), _("What to do if texture coordinates are bigger than image") );
    wrap_r->addOption(_("Clamp"),osg::Texture::CLAMP);
    wrap_r->addOption(_("Clamp to edge"),osg::Texture::CLAMP_TO_EDGE);
    wrap_r->addOption(_("Clamp to border"),osg::Texture::CLAMP_TO_BORDER);
    wrap_r->addOption(_("Repeat"),osg::Texture::REPEAT);
    wrap_r->addOption(_("Mirror"),osg::Texture::MIRROR);
    wrap_r->setInitial(model->getWrap(osg::Texture::WRAP_R));
    
    list.push_back(wrap_r.get());
    border_color = new EdColour( _("Border colour"), _("Ambient colour of back side") );
    border_color->setInitial(model->getBorderColor());
    
    list.push_back(border_color.get());
    min_filter = new EdEnum( _("Min Filter"), _("Filter used when scaling down the texture image") );
    min_filter->addOption(_("Linear"),osg::Texture::LINEAR);
    min_filter->addOption(_("Linear Mipmap Linear"),osg::Texture::LINEAR_MIPMAP_LINEAR);
    min_filter->addOption(_("Linear Mipmap Nearest"),osg::Texture::LINEAR_MIPMAP_NEAREST);
    min_filter->addOption(_("Nearest"),osg::Texture::NEAREST);
    min_filter->addOption(_("Nearest Mipmap Linear"),osg::Texture::NEAREST_MIPMAP_LINEAR);
    min_filter->addOption(_("Nearest Mipmap Nearest"),osg::Texture::NEAREST_MIPMAP_NEAREST);
    min_filter->setInitial(model->getFilter(osg::Texture::MIN_FILTER));
    
    list.push_back(min_filter.get());
    mag_filter = new EdEnum( _("Mag Filter"), _("Filter used when scaling up the texture image") );
    mag_filter->addOption(_("Linear"),osg::Texture::LINEAR);
    mag_filter->addOption(_("Linear Mipmap Linear"),osg::Texture::LINEAR_MIPMAP_LINEAR);
    mag_filter->addOption(_("Linear Mipmap Nearest"),osg::Texture::LINEAR_MIPMAP_NEAREST);
    mag_filter->addOption(_("Nearest"),osg::Texture::NEAREST);
    mag_filter->addOption(_("Nearest Mipmap Linear"),osg::Texture::NEAREST_MIPMAP_LINEAR);
    mag_filter->addOption(_("Nearest Mipmap Nearest"),osg::Texture::NEAREST_MIPMAP_NEAREST);
    mag_filter->setInitial(model->getFilter(osg::Texture::MAG_FILTER));
    
    list.push_back(mag_filter.get());

}

EdTexture::EdTexture() {}

EdTexture::EdTexture(osg::Texture *_model) {
    setObject(_model);
}

void EdTexture::commit() {
    osg::ref_ptr<Command> com =
	new ComTexture(model.get(),
            image_file->get(),
            (osg::Texture::WrapMode)wrap_s->get(),
            (osg::Texture::WrapMode)wrap_t->get(),
            (osg::Texture::WrapMode)wrap_r->get(),
            border_color->get(),
            (osg::Texture::FilterMode)min_filter->get(),
            (osg::Texture::FilterMode)mag_filter->get());
    com->execute();

}
