#ifndef __EdTexMat_H__
#define __EdTexMat_H__

#include <config.h>
#include <osg/TexMat>
#include <editable/editableentity.h>
#include <editable/attributes/all.h>
#include <local.h>

class EdTexMat: public EditableEntity {
public:
    EdTexMat();
    EdTexMat(osg::TexMat *);
    virtual void setObject(osg::Object *object);
    virtual void commit();
    virtual EditableAttributeList getAttributes() { return list; }
    inline virtual std::string getName() const { return _("TexMat"); }
    inline virtual EditableEntity *clone() { return new EdTexMat(); }
    inline virtual void genObject() { setObject(new osg::TexMat()); }
    virtual osg::Object *getObject() { return model.get(); }
private:
    osg::ref_ptr< osg::TexMat > model;
    EditableAttributeList list;
    //Attributes
    osg::ref_ptr< EdMatrix > matrix;
};
#endif //__EdTexMat_H__
