
#include "edtexmat.h"

#include <command/comtexmat.h>


void EdTexMat::setObject(osg::Object *object) {
    model=dynamic_cast<osg::TexMat *> (object);
    if (model == 0) {
	std::cerr << "EdTexMat::setObject(): FATAL ERROR: This is not an 'osg::TexMat'" << std::endl;
        throw -1;
    }
    matrix = new EdMatrix( _("Texture Matrix"), _("The OpenGL Texture Matrix") );
    matrix->setInitial(model->getMatrix());
    std::cout << "Setting initial: " << model->getMatrix()(0,0) << std::endl;

    list.push_back(matrix.get());

}

EdTexMat::EdTexMat() {}

EdTexMat::EdTexMat(osg::TexMat *_model) {
    setObject(_model);
}

void EdTexMat::commit() {
    osg::ref_ptr<Command> com =
	new ComTexMat(model.get(),
            matrix->get());
    com->execute();

}
