#ifndef __EdSwitch_H__
#define __EdSwitch_H__

#include <config.h>
#include <osg/Switch>
#include <editable/editableentity.h>
#include <editable/attributes/all.h>
#include <local.h>

class EdSwitch: public EditableEntity {
public:
    EdSwitch();
    EdSwitch(osg::Switch *);
    virtual void setObject(osg::Object *object);
    virtual void commit();
    virtual EditableAttributeList getAttributes() { return list; }
    inline virtual std::string getName() const { return _("Switch"); }
    inline virtual EditableEntity *clone() { return new EdSwitch(); }
    inline virtual void genObject() { setObject(new osg::Switch()); }
    virtual osg::Object *getObject() { return model.get(); }
private:
    osg::ref_ptr< osg::Switch > model;
    EditableAttributeList list;
    //Attributes
    osg::ref_ptr< EdList > values;
};
#endif //__EdSwitch_H__
