#include "edswitch.h"
#include <command/comactivechild.h>

void EdSwitch::setObject(osg::Object *object) {
    model=dynamic_cast<osg::Switch *> (object);
    if (model == 0) {
	std::cerr << "EdSwitch::setObject(): FATAL ERROR: This is not an 'osg::Switch'" << std::endl;
	throw -1;
    }
    values = new EdList( _("Values"), _("Value of activity of each child node") );

    for (unsigned i=0;i<model->getNumChildren();i++) {
	EditableAttributeList list;
	osg::ref_ptr<EdBool> value;
	value = new EdBool( _("Value"), _("Value of activity of current node"),model->getValue(i) );

	list.push_back(value.get());
	values->add(model->getChild(i)->getName(),list);
    }

    list.push_back(values.get());

};

EdSwitch::EdSwitch() {}

EdSwitch::EdSwitch(osg::Switch *_model) {
    setObject(_model);
}

void EdSwitch::commit() {
    std::vector<bool> active_children;
    for (unsigned i=0;i<model->getNumChildren();i++) {
        const EditableAttributeList &list=values->get(i);
        const EdBool *ed = dynamic_cast<const EdBool*>(list[0].get());
	active_children.push_back(ed->get());
    }
    osg::ref_ptr<ComActiveChild> com = new ComActiveChild(model.get(),active_children);
    com->execute();
}
