#ifndef __EdStateSet_H__
#define __EdStateSet_H__

#include <config.h>
#include <osg/StateSet>
#include <editable/editableentity.h>
#include <editable/attributes/all.h>
#include <local.h>

class EdStateSet: public EditableEntity {
public:
    EdStateSet();
    EdStateSet(osg::StateSet *);
    virtual void setObject(osg::Object *object);
    virtual void commit();
    virtual EditableAttributeList getAttributes() { return list; }
    inline virtual std::string getName() const { return _("StateSet"); }
    inline virtual EditableEntity *clone() { return new EdStateSet(); }
    inline virtual void genObject() { setObject(new osg::StateSet()); }
    virtual osg::Object *getObject() { return model.get(); }
private:
    osg::ref_ptr< osg::StateSet > model;
    EditableAttributeList list;
    //Attributes
    osg::ref_ptr< EdList > modes;
    osg::ref_ptr< EdList > texture_modes;
    osg::ref_ptr< EdEnum > rendering_hint;
};
#endif //__EdStateSet_H__
