#ifndef __EdShadeModel_H__
#define __EdShadeModel_H__

#include <config.h>
#include <osg/ShadeModel>
#include <editable/editableentity.h>
#include <editable/attributes/all.h>
#include <local.h>

class EdShadeModel: public EditableEntity {
public:
    EdShadeModel();
    EdShadeModel(osg::ShadeModel *);
    virtual void setObject(osg::Object *object);
    virtual void commit();
    virtual EditableAttributeList getAttributes() { return list; }
    inline virtual std::string getName() const { return _("Shade Model"); }
    inline virtual EditableEntity *clone() { return new EdShadeModel(); }
    inline virtual void genObject() { setObject(new osg::ShadeModel()); }
    virtual osg::Object *getObject() { return model.get(); }
private:
    osg::ref_ptr< osg::ShadeModel > model;
    EditableAttributeList list;
    //Attributes
    osg::ref_ptr< EdEnum > mode;
};
#endif //__EdShadeModel_H__
