#include "edshademodel.h"

#include <command/comshademodel.h>


void EdShadeModel::setObject(osg::Object *object) {
    model=dynamic_cast<osg::ShadeModel *> (object);
    if (model == 0) {
	std::cerr << "EdShadeModel::setObject(): FATAL ERROR: This is not an 'osg::ShadeModel'" << std::endl;
        throw -1;
    }
    mode = new EdEnum( _("Mode"), _("OpenGL shade model") );
    mode->addOption(_("Flat"),osg::ShadeModel::FLAT);
    mode->addOption(_("Smooth"),osg::ShadeModel::SMOOTH);
    mode->setInitial(model->getMode());
    
    list.push_back(mode.get());

}

EdShadeModel::EdShadeModel() {}

EdShadeModel::EdShadeModel(osg::ShadeModel *_model) {
    setObject(_model);
}

void EdShadeModel::commit() {
    osg::ref_ptr<Command> com =
	new ComShadeModel(model.get(),
            (osg::ShadeModel::Mode)mode->get());
    com->execute();

}
