#ifndef __EdSequence_H__
#define __EdSequence_H__

#include <config.h>
#include <osg/Sequence>
#include <editable/editableentity.h>
#include <editable/attributes/all.h>
#include <local.h>

class EdSequence: public EditableEntity {
public:
    EdSequence();
    EdSequence(osg::Sequence *);
    virtual void setObject(osg::Object *object);
    virtual void commit();
    virtual EditableAttributeList getAttributes() { return list; }
    inline virtual std::string getName() const { return _("Sequence"); }
    inline virtual EditableEntity *clone() { return new EdSequence(); }
    inline virtual void genObject() { setObject(new osg::Sequence()); }
    virtual osg::Object *getObject() { return model.get(); }
private:
    osg::ref_ptr< osg::Sequence > model;
    EditableAttributeList list;
    //Attributes
    osg::ref_ptr< EdEnum > loop_mode;
    osg::ref_ptr< EdInt > loop_begin;
    osg::ref_ptr< EdInt > loop_end;
    osg::ref_ptr< EdFloat > speed;
    osg::ref_ptr< EdInt > repetitions;
    osg::ref_ptr< EdList > times;
};
#endif //__EdSequence_H__
