#include "edsequence.h"
#include <glib.h> // G_MINFLOAT, G_MAXFLOAT
#include <command/comsequence.h>

void EdSequence::setObject(osg::Object *object) {
    model=dynamic_cast<osg::Sequence *> (object);
    if (model == 0) {
	std::cerr << "EdSequence::setObject(): FATAL ERROR: This is not an 'osg::Sequence'" << std::endl;
	throw -1;
    }
    osg::Sequence::LoopMode mode;
    int begin, end;
    model->getInterval(mode, begin, end);

    loop_mode = new EdEnum( _("Loop Mode"), _("Mode of the loop") );
    loop_mode->addOption(_("Loop"),osg::Sequence::LOOP);
    loop_mode->addOption(_("Swing"),osg::Sequence::SWING);
    loop_mode->setInitial(mode);

    list.push_back(loop_mode.get());
    loop_begin = new EdInt( _("Begin of loop"), _("The frame where the loop begins"), begin, 0, model->getNumChildren() );

    list.push_back(loop_begin.get());
    loop_end = new EdInt( _("End of loop"), _("The frame where the loop ends"), begin, 0, model->getNumChildren());

    float _speed;
    int nreps;
    model->getDuration(_speed, nreps);

    list.push_back(loop_end.get());
    speed = new EdFloat( _("Speed"), _("The speed of the sequence"), _speed, 0, G_MAXFLOAT );

    list.push_back(speed.get());
    repetitions = new EdInt( _("Repetitions"), _("Repetitions of the loop"), nreps, 0, G_MAXINT );

    list.push_back(repetitions.get());
    times = new EdList( _("Times"), _("Time for each frame") );

    for (unsigned i=0;i<model->getNumChildren();i++) {
	EditableAttributeList list;
	osg::ref_ptr<EdFloat> time;
	time = new EdFloat( _("Time"), _("Time for current frame"), model->getTime(i), 0, G_MAXFLOAT );

	//FILL_ME: Initialize time
	list.push_back(time.get());
	times->add(model->getChild(i)->getName(),list);
    }

    list.push_back(times.get());

};

EdSequence::EdSequence() {}

EdSequence::EdSequence(osg::Sequence *_model) {
    setObject(_model);
}

void EdSequence::commit() {
    std::vector<float> _times;
    for (unsigned i=0;i<model->getNumChildren();i++) {
        const EditableAttributeList &list=times->get(i);
        const EdFloat *time = dynamic_cast<const EdFloat*>(list[0].get());
        _times.push_back(time->get());
    }

    osg::ref_ptr<ComSequence> com =
	new ComSequence(model.get(),
			(osg::Sequence::LoopMode)loop_mode->get(),
			loop_begin->get(),
			loop_end->get(),
			speed->get(),
			repetitions->get(),
			_times);
    com->execute();
}
