#ifndef __EdMaterial_H__
#define __EdMaterial_H__

#include <config.h>
#include <osg/Material>
#include <editable/editableentity.h>
#include <editable/attributes/all.h>
#include <local.h>

class EdMaterial: public EditableEntity {
public:
    EdMaterial();
    EdMaterial(osg::Material *);
    virtual void setObject(osg::Object *object);
    virtual void commit();
    virtual EditableAttributeList getAttributes() { return list; }
    inline virtual std::string getName() const { return _("Material"); }
    inline virtual EditableEntity *clone() { return new EdMaterial(); }
    inline virtual void genObject() { setObject(new osg::Material()); }
    virtual osg::Object *getObject() { return model.get(); }
private:
    osg::ref_ptr< osg::Material > model;
    EditableAttributeList list;
    //Attributes
    osg::ref_ptr< EdColour > ambient_front;
    osg::ref_ptr< EdColour > ambient_back;
    osg::ref_ptr< EdColour > diffuse_front;
    osg::ref_ptr< EdColour > diffuse_back;
    osg::ref_ptr< EdColour > specular_front;
    osg::ref_ptr< EdColour > specular_back;
    osg::ref_ptr< EdColour > emission_front;
    osg::ref_ptr< EdColour > emission_back;
    osg::ref_ptr< EdFloat > shininess_front;
    osg::ref_ptr< EdFloat > shininess_back;
};
#endif //__EdMaterial_H__
