#include "edmaterial.h"

#include <command/commaterial.h>


void EdMaterial::setObject(osg::Object *object) {
    model=dynamic_cast<osg::Material *> (object);
    if (model == 0) {
	std::cerr << "EdMaterial::setObject(): FATAL ERROR: This is not an 'osg::Material'" << std::endl;
        throw -1;
    }
    ambient_front = new EdColour( _("Ambient Front"), _("Ambient colour of front side") );
    ambient_front->setInitial(model->getAmbient(osg::Material::FRONT));
    
    list.push_back(ambient_front.get());
    ambient_back = new EdColour( _("Ambient Back"), _("Ambient colour of back side") );
    ambient_back->setInitial(model->getAmbient(osg::Material::BACK));
    
    list.push_back(ambient_back.get());
    diffuse_front = new EdColour( _("Diffuse Front"), _("Diffuse colour of front side") );
    diffuse_front->setInitial(model->getDiffuse(osg::Material::FRONT));
    
    list.push_back(diffuse_front.get());
    diffuse_back = new EdColour( _("Diffuse Back"), _("Diffuse colour of back side") );
    diffuse_back->setInitial(model->getDiffuse(osg::Material::BACK));
    
    list.push_back(diffuse_back.get());
    specular_front = new EdColour( _("Specular Front"), _("Specular colour of front side") );
    specular_front->setInitial(model->getSpecular(osg::Material::FRONT));
    
    list.push_back(specular_front.get());
    specular_back = new EdColour( _("Specular Back"), _("Specular colour of back side") );
    specular_back->setInitial(model->getSpecular(osg::Material::BACK));
    
    list.push_back(specular_back.get());
    emission_front = new EdColour( _("Emission Front"), _("Emission colour of front side") );
    emission_front->setInitial(model->getEmission(osg::Material::FRONT));
    
    list.push_back(emission_front.get());
    emission_back = new EdColour( _("Emission Back"), _("Emission colour of back side") );
    emission_back->setInitial(model->getEmission(osg::Material::BACK));
    
    list.push_back(emission_back.get());
    shininess_front = new EdFloat( _("Shininess Front"), _("Shininess value for front face") );
    shininess_front->setInitial(model->getShininess(osg::Material::FRONT));
    
    list.push_back(shininess_front.get());
    shininess_back = new EdFloat( _("Shininess Back"), _("Shininess value for back face") );
    shininess_back->setInitial(model->getShininess(osg::Material::BACK));
    
    list.push_back(shininess_back.get());

}

EdMaterial::EdMaterial() {}

EdMaterial::EdMaterial(osg::Material *_model) {
    setObject(_model);
}

void EdMaterial::commit() {
    osg::ref_ptr<Command> com =
	new ComMaterial(model.get(),
            ambient_front->get(),
            ambient_back->get(),
            diffuse_front->get(),
            diffuse_back->get(),
            specular_front->get(),
            specular_back->get(),
            emission_front->get(),
            emission_back->get(),
            shininess_front->get(),
            shininess_back->get());
    com->execute();

}
