#ifndef __EdLOD_H__
#define __EdLOD_H__

#include <config.h>
#include <osg/LOD>
#include <editable/editableentity.h>
#include <editable/attributes/all.h>
#include <local.h>

class EdLOD: public EditableEntity {
public:
    EdLOD();
    EdLOD(osg::LOD *);
    virtual void setObject(osg::Object *object);
    virtual void commit();
    virtual EditableAttributeList getAttributes() { return list; }
    inline virtual std::string getName() const { return _("LOD"); }
    inline virtual EditableEntity *clone() { return new EdLOD(); }
    inline virtual void genObject() { setObject(new osg::LOD()); }
    virtual osg::Object *getObject() { return model.get(); }
private:
    osg::ref_ptr< osg::LOD > model;
    EditableAttributeList list;
    //Attributes
    osg::ref_ptr< EdEnum > center_mode;
    osg::ref_ptr< EdVec3 > center;
    osg::ref_ptr< EdList > ranges;
};
#endif //__EdLOD_H__
