#include "edlod.h"
#include <glib.h> // G_MINFLOAT, G_MAXFLOAT
#include <command/comlod.h>

void EdLOD::setObject(osg::Object *object) {
    model=dynamic_cast<osg::LOD *> (object);
    if (model == 0) {
	std::cerr << "EdLOD::setObject(): FATAL ERROR: This is not an 'osg::LOD'" << std::endl;
	throw -1;
    }
    center_mode = new EdEnum( _("Center mode"), _("Mode to calculate the distance to camera") );
    center_mode->addOption(_("Bounding sphere center"),osg::LOD::USE_BOUNDING_SPHERE_CENTER);
    center_mode->addOption(_("User defined center"),osg::LOD::USER_DEFINED_CENTER);
    center_mode->setInitial(model->getCenterMode());

    list.push_back(center_mode.get());
    center = new EdVec3( _("Center"), _("Center used in USER_DEFINED_CENTER mode to calculate distance to camera") );
    center->setInitial(model->getCenter());

    list.push_back(center.get());
    ranges = new EdList( _("Ranges"), _("Ranges of distance to camera in which each child is visible") );

    for (unsigned i=0;i<model->getNumChildren();i++) {
	EditableAttributeList list;
	osg::ref_ptr<EdFloat> min;
	osg::ref_ptr<EdFloat> max;
	min = new EdFloat( _("Min"), _("Minimum distance to camera to see this node"), model->getMinRange(i), 0, G_MAXFLOAT);

	list.push_back(min.get());
	max = new EdFloat( _("Max"), _("Maximum distance to camera to see this node"), model->getMaxRange(i), 0, G_MAXFLOAT );

	list.push_back(max.get());
	ranges->add(model->getChild(i)->getName(),list);
    }

    list.push_back(ranges.get());

};

EdLOD::EdLOD() {}

EdLOD::EdLOD(osg::LOD *_model) {
    setObject(_model);
}

void EdLOD::commit() {
    osg::LOD::RangeList _ranges;
    for (unsigned i=0;i<model->getNumChildren();i++) {
        const EditableAttributeList &list=ranges->get(i);
        const EdFloat *edmin = dynamic_cast<const EdFloat*>(list[0].get());
        const EdFloat *edmax = dynamic_cast<const EdFloat*>(list[1].get());

	osg::LOD::MinMaxPair pair(edmin->get(),edmax->get());
        _ranges.push_back(pair);

    }
    osg::ref_ptr<ComLOD> com =
	new ComLOD(model.get(),
		   (osg::LOD::CenterMode)center_mode->get(),
		   center->get(),
		   _ranges);
    com->execute();
}
