#ifndef __EdLightSource_H__
#define __EdLightSource_H__

#include <config.h>
#include <osg/LightSource>
#include <editable/editableentity.h>
#include <editable/attributes/all.h>
#include <editable/entities/edlight.h>
#include <local.h>

/** @class Wrapper for light sources
 * @brief this class is not an editor, it delegates in the editable of
 * light for the light associated with this light source.
 */
class EdLightSource: public EditableEntity {
public:
    EdLightSource();
    EdLightSource(osg::LightSource *);
    virtual void setObject(osg::Object *object);
    virtual void commit();
    virtual EditableAttributeList getAttributes();
    inline virtual std::string getName() const { return _("Light Source"); }
    inline virtual EditableEntity *clone() { return new EdLightSource(); }
    inline virtual void genObject() { setObject(new osg::LightSource()); }
    virtual osg::Object *getObject() { return light->getObject(); }
private:
    //Attributes
    osg::ref_ptr<EdLight> light;
};
#endif //__EdLightSource_H__
