#include "edlightsource.h"

void EdLightSource::setObject(osg::Object *object) {
    light=new EdLight();
    osg::LightSource *model=dynamic_cast<osg::LightSource *> (object);

    light->setObject(model->getLight());
}

EdLightSource::EdLightSource() {}

EdLightSource::EdLightSource(osg::LightSource *_model) {
    setObject(_model);
}

EditableAttributeList EdLightSource::getAttributes() {
    if (light != 0) {
	return light->getAttributes();
    } else {
	std::cerr << "EdLightSource::getAttributes(): FATAL ERROR: There is not assigned light" << std::endl;
        throw -1;
    }
}

void EdLightSource::commit() {
    if (light != 0) {
	light->commit();
    }
}
