#ifndef __EdLightModel_H__
#define __EdLightModel_H__

#include <config.h>
#include <osg/LightModel>
#include <editable/editableentity.h>
#include <editable/attributes/all.h>
#include <local.h>

class EdLightModel: public EditableEntity {
public:
    EdLightModel();
    EdLightModel(osg::LightModel *);
    virtual void setObject(osg::Object *object);
    virtual void commit();
    virtual EditableAttributeList getAttributes() { return list; }
    inline virtual std::string getName() const { return _("Shade Model"); }
    inline virtual EditableEntity *clone() { return new EdLightModel(); }
    inline virtual void genObject() { setObject(new osg::LightModel()); }
    virtual osg::Object *getObject() { return model.get(); }
private:
    osg::ref_ptr< osg::LightModel > model;
    EditableAttributeList list;
    //Attributes
    osg::ref_ptr< EdColour > ambient_intensity;
    osg::ref_ptr< EdEnum > color_control;
    osg::ref_ptr< EdBool > local_viewer;
    osg::ref_ptr< EdBool > two_sided;
};
#endif //__EdLightModel_H__
