#include "edlightmodel.h"

#include <command/comlightmodel.h>


void EdLightModel::setObject(osg::Object *object) {
    model=dynamic_cast<osg::LightModel *> (object);
    if (model == 0) {
	std::cerr << "EdLightModel::setObject(): FATAL ERROR: This is not an 'osg::LightModel'" << std::endl;
        throw -1;
    }
    ambient_intensity = new EdColour( _("Ambient intensity"), _("Specify the ambient  RGBA  intensity  of  the  entire  scene.") );
    ambient_intensity->setInitial(model->getAmbientIntensity());
    
    list.push_back(ambient_intensity.get());
    color_control = new EdEnum( _("Color control"), _("Do separate calculations for specular colour or not") );
    color_control->addOption(_("Separate specular color"),osg::LightModel::SEPARATE_SPECULAR_COLOR);
    color_control->addOption(_("Single color"),osg::LightModel::SINGLE_COLOR);
    color_control->setInitial(model->getColorControl());
    
    list.push_back(color_control.get());
    local_viewer = new EdBool( _("Local viewer"), _("Specifies how specular reflection angles are computed.                  If false, specular  reflection  angles  take  the  view                  direction  to  be  parallel to and in the direction of the -z                  axis, regardless of the location of the vertex in eye coordi-                  nates.  If true, specular reflections are computed from the                  origin of the eye coordinate system."),model->getLocalViewer() );
    
    list.push_back(local_viewer.get());
    two_sided = new EdBool( _("Two sided"), _("Specifies whether one- or  two-sided  lighting  calculations  are    done for polygons."),model->getTwoSided() );
    
    list.push_back(two_sided.get());

}

EdLightModel::EdLightModel() {}

EdLightModel::EdLightModel(osg::LightModel *_model) {
    setObject(_model);
}

void EdLightModel::commit() {
    osg::ref_ptr<Command> com =
	new ComLightModel(model.get(),
            ambient_intensity->get(),
            (osg::LightModel::ColorControl)color_control->get(),
            local_viewer->get(),
            two_sided->get());
    com->execute();

}
