#ifndef __EdLight_H__
#define __EdLight_H__

#include <config.h>
#include <osg/Light>
#include <editable/editableentity.h>
#include <editable/attributes/all.h>
#include <local.h>

class EdLight: public EditableEntity {
public:
    EdLight();
    EdLight(osg::Light *);
    virtual void setObject(osg::Object *object);
    virtual void commit();
    virtual EditableAttributeList getAttributes() { return list; }
    inline virtual std::string getName() const { return _("Light"); }
    inline virtual EditableEntity *clone() { return new EdLight(); }
    inline virtual void genObject() { setObject(new osg::Light()); }
    virtual osg::Object *getObject() { return model.get(); }
private:
    osg::ref_ptr< osg::Light > model;
    EditableAttributeList list;
    //Attributes
    osg::ref_ptr< EdInt > light_num;
    osg::ref_ptr< EdColour > ambient;
    osg::ref_ptr< EdColour > diffuse;
    osg::ref_ptr< EdColour > specular;
    osg::ref_ptr< EdVec3 > position;
    osg::ref_ptr< EdBool > directional;
    osg::ref_ptr< EdVec3 > direction;
    osg::ref_ptr< EdFloat > constant_attenuation;
    osg::ref_ptr< EdFloat > linear_attenuation;
    osg::ref_ptr< EdFloat > quadratic_attenuation;
    osg::ref_ptr< EdFloat > spot_exponent;
    osg::ref_ptr< EdFloat > spot_cutoff;
};
#endif //__EdLight_H__
