#include "edlight.h"
#include <command/comlightsource.h>

void EdLight::setObject(osg::Object *object) {
    model=dynamic_cast<osg::Light *> (object);
    if (model == 0) {
	std::cerr << "EdLight::setObject(): FATAL ERROR: This is not an 'osg::Light'" << std::endl;
	throw -1;
    }

    light_num = new EdInt( _("OpenGL light number"), _("The OpenGL number to store this light"), model->getLightNum(), 0, 128 );

    list.push_back(light_num.get());
    ambient = new EdColour( _("Ambient"), _("Ambient lighting component") );
    ambient->setInitial(model->getAmbient());

    list.push_back(ambient.get());
    diffuse = new EdColour( _("Diffuse"), _("Diffuse lighting component") );
    diffuse->setInitial(model->getDiffuse());

    list.push_back(diffuse.get());
    specular = new EdColour( _("Specular"), _("Specular lighting component") );
    specular->setInitial(model->getSpecular());

    osg::Vec4 pos=model->getPosition();
    list.push_back(specular.get());
    position = new EdVec3( _("Position"), _("Position of the light") );
    position->setInitial(osg::Vec3(pos[0], pos[1], pos[2]));

    list.push_back(position.get());
    directional = new EdBool( _("Directional Light"), _("True=Directional, False=Infinite"),(pos[3]==0) );

    list.push_back(directional.get());
    direction = new EdVec3( _("Direction"), _("Direction of the light") );
    direction->setInitial(model->getDirection());

    list.push_back(direction.get());
    constant_attenuation = new EdFloat( _("Constant Attenuation"), _("Constant attenuation of the light") );
    constant_attenuation->setInitial(model->getConstantAttenuation());

    list.push_back(constant_attenuation.get());
    linear_attenuation = new EdFloat( _("Linear Attenuation"), _("Linear attenuation of the light") );
    linear_attenuation->setInitial(model->getLinearAttenuation());

    list.push_back(linear_attenuation.get());
    quadratic_attenuation = new EdFloat( _("Quadratic Attenuation"), _("Quadratic attenuation of the light") );
    quadratic_attenuation->setInitial(model->getQuadraticAttenuation());

    list.push_back(quadratic_attenuation.get());
    spot_exponent = new EdFloat( _("Spot Exponent"), _("The intensity distribution of the light") );
    spot_exponent->setInitial(model->getSpotExponent());

    list.push_back(spot_exponent.get());
    spot_cutoff = new EdFloat( _("Spot Cutoff"), _("Maximum spread angle of a light source") );
    spot_cutoff->setInitial(model->getSpotCutoff());

    list.push_back(spot_cutoff.get());

};

EdLight::EdLight() {}

EdLight::EdLight(osg::Light *_model) {
    setObject(_model);
}

void EdLight::commit() {
    osg::Vec3 real_pos=position->get();
    osg::Vec4 pos(real_pos[0], real_pos[1], real_pos[2], directional->get()?0:1);
    osg::ref_ptr<ComLightSource> com =
	new ComLightSource(model.get(),
			   light_num->get(),
			   ambient->get(),
			   diffuse->get(),
			   specular->get(),
			   pos,
			   direction->get(),
			   constant_attenuation->get(),
			   linear_attenuation->get(),
			   quadratic_attenuation->get(),
			   spot_exponent->get(),
			   spot_cutoff->get());
    com->execute();
}
