#ifndef __EdFrontFace_H__
#define __EdFrontFace_H__

#include <config.h>
#include <osg/FrontFace>
#include <editable/editableentity.h>
#include <editable/attributes/all.h>
#include <local.h>

class EdFrontFace: public EditableEntity {
public:
    EdFrontFace();
    EdFrontFace(osg::FrontFace *);
    virtual void setObject(osg::Object *object);
    virtual void commit();
    virtual EditableAttributeList getAttributes() { return list; }
    inline virtual std::string getName() const { return _("Shade Model"); }
    inline virtual EditableEntity *clone() { return new EdFrontFace(); }
    inline virtual void genObject() { setObject(new osg::FrontFace()); }
    virtual osg::Object *getObject() { return model.get(); }
private:
    osg::ref_ptr< osg::FrontFace > model;
    EditableAttributeList list;
    //Attributes
    osg::ref_ptr< EdEnum > mode;
};
#endif //__EdFrontFace_H__
