#include "edfrontface.h"

#include <command/comfrontface.h>


void EdFrontFace::setObject(osg::Object *object) {
    model=dynamic_cast<osg::FrontFace *> (object);
    if (model == 0) {
	std::cerr << "EdFrontFace::setObject(): FATAL ERROR: This is not an 'osg::FrontFace'" << std::endl;
        throw -1;
    }
    mode = new EdEnum( _("Mode"), _("Specifies  the  orientation  of front-facing polygons") );
    mode->addOption(_("Clock wise"),osg::FrontFace::CLOCKWISE);
    mode->addOption(_("Counter clock wise"),osg::FrontFace::COUNTER_CLOCKWISE);
    mode->setInitial(model->getMode());
    
    list.push_back(mode.get());

}

EdFrontFace::EdFrontFace() {}

EdFrontFace::EdFrontFace(osg::FrontFace *_model) {
    setObject(_model);
}

void EdFrontFace::commit() {
    osg::ref_ptr<Command> com =
	new ComFrontFace(model.get(),
            (osg::FrontFace::Mode)mode->get());
    com->execute();

}
