#ifndef __EdFog_H__
#define __EdFog_H__

#include <config.h>
#include <osg/Fog>
#include <editable/editableentity.h>
#include <editable/attributes/all.h>
#include <local.h>

class EdFog: public EditableEntity {
public:
    EdFog();
    EdFog(osg::Fog *);
    virtual void setObject(osg::Object *object);
    virtual void commit();
    virtual EditableAttributeList getAttributes() { return list; }
    inline virtual std::string getName() const { return _("Fog"); }
    inline virtual EditableEntity *clone() { return new EdFog(); }
    inline virtual void genObject() { setObject(new osg::Fog()); }
    virtual osg::Object *getObject() { return model.get(); }
private:
    osg::ref_ptr< osg::Fog > model;
    EditableAttributeList list;
    //Attributes
    osg::ref_ptr< EdEnum > mode;
    osg::ref_ptr< EdFloat > density;
    osg::ref_ptr< EdFloat > start;
    osg::ref_ptr< EdFloat > end;
    osg::ref_ptr< EdColour > colour;
    osg::ref_ptr< EdEnum > coord_source;
};
#endif //__EdFog_H__
