
#include "edfog.h"

#include <command/comfog.h>


void EdFog::setObject(osg::Object *object) {
    model=dynamic_cast<osg::Fog *> (object);
    if (model == 0) {
	std::cerr << "EdFog::setObject(): FATAL ERROR: This is not an 'osg::Fog'" << std::endl;
        throw -1;
    }
    mode = new EdEnum( _("Mode"), _("Equation to be used to compute the fog blend factor") );
    mode->addOption(_("Linear"),osg::Fog::LINEAR);
    mode->addOption(_("Exponential"),osg::Fog::EXP);
    mode->addOption(_("Square Exponential"),osg::Fog::EXP2);
    mode->setInitial(model->getMode());
    
    list.push_back(mode.get());
    density = new EdFloat( _("Density"), _("Density for non-linear fog") );
    density->setInitial(model->getDensity());
    
    list.push_back(density.get());
    start = new EdFloat( _("Start"), _("Near distance where fog starts") );
    start->setInitial(model->getStart());
    
    list.push_back(start.get());
    end = new EdFloat( _("End"), _("Far distance where fog ends") );
    end->setInitial(model->getEnd());
    
    list.push_back(end.get());
    colour = new EdColour( _("Colour"), _("Colour of the fog") );
    colour->setInitial(model->getColor());
    
    list.push_back(colour.get());
    coord_source = new EdEnum( _("Coordinate Source"), _("Use GL_EXT_fog_coord extension to specify per-vertex fog coordinates, or use fragment depth") );
    coord_source->addOption(_("Per-Vertex coordinates"),osg::Fog::FOG_COORDINATE);
    coord_source->addOption(_("Fragment depth"),osg::Fog::FRAGMENT_DEPTH);
    coord_source->setInitial(model->getFogCoordinateSource());
    
    list.push_back(coord_source.get());
}

EdFog::EdFog() {}

EdFog::EdFog(osg::Fog *_model) {
    setObject(_model);
}

void EdFog::commit() {
    osg::ref_ptr<Command> com =
	new ComFog(model.get(),
            (osg::Fog::Mode)mode->get(),
            density->get(),
            start->get(),
            end->get(),
            colour->get(),
            (GLint)coord_source->get());
    com->execute();

}
