#ifndef __EdCullFace_H__
#define __EdCullFace_H__

#include <config.h>
#include <osg/CullFace>
#include <editable/editableentity.h>
#include <editable/attributes/all.h>
#include <local.h>

class EdCullFace: public EditableEntity {
public:
    EdCullFace();
    EdCullFace(osg::CullFace *);
    virtual void setObject(osg::Object *object);
    virtual void commit();
    virtual EditableAttributeList getAttributes() { return list; }
    inline virtual std::string getName() const { return _("Shade Model"); }
    inline virtual EditableEntity *clone() { return new EdCullFace(); }
    inline virtual void genObject() { setObject(new osg::CullFace()); }
    virtual osg::Object *getObject() { return model.get(); }
private:
    osg::ref_ptr< osg::CullFace > model;
    EditableAttributeList list;
    //Attributes
    osg::ref_ptr< EdEnum > mode;
};
#endif //__EdCullFace_H__
