#include "edcullface.h"

#include <command/comcullface.h>


void EdCullFace::setObject(osg::Object *object) {
    model=dynamic_cast<osg::CullFace *> (object);
    if (model == 0) {
	std::cerr << "EdCullFace::setObject(): FATAL ERROR: This is not an 'osg::CullFace'" << std::endl;
        throw -1;
    }
    mode = new EdEnum( _("Mode"), _("Specifies whether front- or back-facing facets are hidden to speed up render") );
    mode->addOption(_("Hide front face"),osg::CullFace::FRONT);
    mode->addOption(_("Hide back face"),osg::CullFace::BACK);
    mode->addOption(_("Hide both faces"),osg::CullFace::FRONT_AND_BACK);
    mode->setInitial(model->getMode());
    
    list.push_back(mode.get());

}

EdCullFace::EdCullFace() {}

EdCullFace::EdCullFace(osg::CullFace *_model) {
    setObject(_model);
}

void EdCullFace::commit() {
    osg::ref_ptr<Command> com =
	new ComCullFace(model.get(),
            (osg::CullFace::Mode)mode->get());
    com->execute();

}
