#ifndef __EdCfgView_H__
#define __EdCfgView_H__

#include <config.h>
#include <appconfig.h>
#include <editable/editableentity.h>
#include <editable/attributes/all.h>
#include <local.h>

class EdCfgView: public EditableEntity {
public:
    EdCfgView();
    EdCfgView(CfgView *);
    virtual void setObject(osg::Object *object);
    virtual void commit();
    virtual EditableAttributeList getAttributes() { return list; }
    inline virtual std::string getName() const { return _("CfgView"); }
    inline virtual EditableEntity *clone() { return new EdCfgView(); }
    inline virtual void genObject() { setObject(new CfgView()); }
    inline virtual osg::Object *getObject() { return model.get(); }
private:
    osg::ref_ptr< CfgView > model;
    EditableAttributeList list;
    //Attributes
    osg::ref_ptr< EdEnum > axis_system;
    osg::ref_ptr< EdEnum > projection_type;
    osg::ref_ptr< EdEnum > view_type;
};
#endif //__EdCfgView_H__
