#include "edcfgview.h"


void EdCfgView::setObject(osg::Object *object) {
    model=dynamic_cast<CfgView *> (object);
    if (model == 0) {
	std::cerr << "EdCfgView::setObject(): FATAL ERROR: This is not an 'CfgView'" << std::endl;
	throw -1;
    }
    axis_system = new EdEnum( _("Axis system"), _("Type of axis system used in osgedit, Y-UP or Z-UP") );
    axis_system->addOption(_("Y-UP"),CameraView::Y_UP);
    axis_system->addOption(_("Z-UP"),CameraView::Z_UP);
    axis_system->setInitial(model->getAxisSystem());

    list.push_back(axis_system.get());
    projection_type = new EdEnum( _("Projection Type"), _("Type of projection, orthogonal or perspective") );
    projection_type->addOption(_("Orthogonal"),CameraView::ORTHOGONAL);
    projection_type->addOption(_("Perspective"),CameraView::PERSPECTIVE);
    projection_type->setInitial(model->getProjectionType());

    list.push_back(projection_type.get());
    view_type = new EdEnum( _("Initial view"), _("Point of view when the application is started") );
    view_type->addOption(_("Front"),CameraView::FRONT);
    view_type->addOption(_("Back"),CameraView::BACK);
    view_type->addOption(_("Top"),CameraView::TOP);
    view_type->addOption(_("Bottom"),CameraView::BOTTOM);
    view_type->addOption(_("Left"),CameraView::LEFT);
    view_type->addOption(_("Right"),CameraView::RIGHT);
    view_type->setInitial(model->getViewType());

    list.push_back(view_type.get());

}

EdCfgView::EdCfgView() {}

EdCfgView::EdCfgView(CfgView *_model) {
    setObject(_model);
}

void EdCfgView::commit() {
    if (axis_system->hasChanged() == true) {
	model->setAxisSystem((CameraView::AxisSystem)axis_system->get());
    }
    if (projection_type->hasChanged() == true) {
	model->setProjectionType((CameraView::ProjectionType)projection_type->get());
    }
    if (view_type->hasChanged() == true) {
	model->setViewType((CameraView::ViewType)view_type->get());
    }
}
