#ifndef __EdCfgGrid_H__
#define __EdCfgGrid_H__

#include <config.h>
#include <appconfig.h>
#include <editable/editableentity.h>
#include <editable/attributes/all.h>
#include <local.h>

class EdCfgGrid: public EditableEntity {
public:
    EdCfgGrid();
    EdCfgGrid(CfgGrid *);
    virtual void setObject(osg::Object *object);
    virtual void commit();
    virtual EditableAttributeList getAttributes() { return list; }
    inline virtual std::string getName() const { return _("CfgGrid"); }
    inline virtual EditableEntity *clone() { return new EdCfgGrid(); }
    inline virtual void genObject() { setObject(new CfgGrid()); }
    inline virtual osg::Object *getObject() { return model.get(); }
private:
    osg::ref_ptr< CfgGrid > model;
    EditableAttributeList list;
    //Attributes
    osg::ref_ptr< EdFloat > unit_size;
    osg::ref_ptr< EdFloat > edge_size;
    osg::ref_ptr< EdColour > grid_colour;
    osg::ref_ptr< EdColour > axis_colour;
};
#endif //__EdCfgGrid_H__
