#include "edcfggrid.h"


void EdCfgGrid::setObject(osg::Object *object) {
    model=dynamic_cast<CfgGrid *> (object);
    if (model == 0) {
	std::cerr << "EdCfgGrid::setObject(): FATAL ERROR: This is not an 'CfgGrid'" << std::endl;
	throw -1;
    }
    unit_size = new EdFloat( _("Unit size"), _("Distance between grid lines") );
    unit_size->setInitial(model->getUnitSize());

    list.push_back(unit_size.get());
    edge_size = new EdFloat( _("Edge size"), _("Size from the center axis to the edge of the grid") );
    edge_size->setInitial(model->getEdgeSize());

    list.push_back(edge_size.get());
    grid_colour = new EdColour( _("Grid colour"), _("Colour of the grid") );
    grid_colour->setInitial(model->getGridColor());

    list.push_back(grid_colour.get());
    axis_colour = new EdColour( _("Axis colour"), _("Colour of the axis in the center of the grid") );
    axis_colour->setInitial(model->getAxisColor());

    list.push_back(axis_colour.get());

}

EdCfgGrid::EdCfgGrid() {}

EdCfgGrid::EdCfgGrid(CfgGrid *_model) {
    setObject(_model);
}

void EdCfgGrid::commit() {
    if (unit_size->hasChanged() == true) {
	model->setUnitSize(unit_size->get());
    }
    if (edge_size->hasChanged() == true) {
	model->setEdgeSize(edge_size->get());
    }
    if (grid_colour->hasChanged() == true) {
	model->setGridColor(grid_colour->get());
    }
    if (axis_colour->hasChanged() == true) {
	model->setAxisColor(axis_colour->get());
    }
}
