#ifndef __EdBlendFunc_H__
#define __EdBlendFunc_H__

#include <config.h>
#include <osg/BlendFunc>
#include <editable/editableentity.h>
#include <editable/attributes/all.h>
#include <local.h>

class EdBlendFunc: public EditableEntity {
public:
    EdBlendFunc();
    EdBlendFunc(osg::BlendFunc *);
    virtual void setObject(osg::Object *object);
    virtual void commit();
    virtual EditableAttributeList getAttributes() { return list; }
    inline virtual std::string getName() const { return _("Shade Model"); }
    inline virtual EditableEntity *clone() { return new EdBlendFunc(); }
    inline virtual void genObject() { setObject(new osg::BlendFunc()); }
    virtual osg::Object *getObject() { return model.get(); }
private:
    osg::ref_ptr< osg::BlendFunc > model;
    EditableAttributeList list;
    //Attributes
    osg::ref_ptr< EdEnum > source;
    osg::ref_ptr< EdEnum > destination;
};
#endif //__EdBlendFunc_H__
