#include "edblendfunc.h"

#include <command/comblendfunc.h>


void EdBlendFunc::setObject(osg::Object *object) {
    model=dynamic_cast<osg::BlendFunc *> (object);
    if (model == 0) {
	std::cerr << "EdBlendFunc::setObject(): FATAL ERROR: This is not an 'osg::BlendFunc'" << std::endl;
        throw -1;
    }
    source = new EdEnum( _("Source"), _("Specifies  how the red, green, blue, and alpha source blending                             factors are computed") );
    source->addOption(_("Destination alpha"),osg::BlendFunc::DST_ALPHA);
    source->addOption(_("Destination colour"),osg::BlendFunc::DST_COLOR);
    source->addOption(_("One"),osg::BlendFunc::ONE);
    source->addOption(_("One minus dest. alpha"),osg::BlendFunc::ONE_MINUS_DST_ALPHA);
    source->addOption(_("One minus dest. colour"),osg::BlendFunc::ONE_MINUS_DST_COLOR);
    source->addOption(_("One minus source alpha"),osg::BlendFunc::ONE_MINUS_SRC_ALPHA);
    source->addOption(_("One minus source colour"),osg::BlendFunc::ONE_MINUS_SRC_COLOR);
    source->addOption(_("Source alpha"),osg::BlendFunc::SRC_ALPHA);
    source->addOption(_("Source alpha saturate"),osg::BlendFunc::SRC_ALPHA_SATURATE);
    source->addOption(_("Source colour"),osg::BlendFunc::SRC_COLOR);
    source->addOption(_("Zero"),osg::BlendFunc::ZERO);
    source->setInitial(model->getSource());
    
    list.push_back(source.get());
    destination = new EdEnum( _("Destination"), _("Specifies  how the red, green, blue, and alpha destination blending                             factors are computed") );
    destination->addOption(_("Destination alpha"),osg::BlendFunc::DST_ALPHA);
    destination->addOption(_("Destination colour"),osg::BlendFunc::DST_COLOR);
    destination->addOption(_("One"),osg::BlendFunc::ONE);
    destination->addOption(_("One minus dest. alpha"),osg::BlendFunc::ONE_MINUS_DST_ALPHA);
    destination->addOption(_("One minus dest. colour"),osg::BlendFunc::ONE_MINUS_DST_COLOR);
    destination->addOption(_("One minus source alpha"),osg::BlendFunc::ONE_MINUS_SRC_ALPHA);
    destination->addOption(_("One minus source colour"),osg::BlendFunc::ONE_MINUS_SRC_COLOR);
    destination->addOption(_("Source alpha"),osg::BlendFunc::SRC_ALPHA);
    destination->addOption(_("Source alpha saturate"),osg::BlendFunc::SRC_ALPHA_SATURATE);
    destination->addOption(_("Source colour"),osg::BlendFunc::SRC_COLOR);
    destination->addOption(_("Zero"),osg::BlendFunc::ZERO);
    destination->setInitial(model->getDestination());
    
    list.push_back(destination.get());

}

EdBlendFunc::EdBlendFunc() {}

EdBlendFunc::EdBlendFunc(osg::BlendFunc *_model) {
    setObject(_model);
}

void EdBlendFunc::commit() {
    osg::ref_ptr<Command> com =
	new ComBlendFunc(model.get(),
            (osg::BlendFunc::BlendFuncMode)source->get(),
            (osg::BlendFunc::BlendFuncMode)destination->get());
    com->execute();

}
