#ifndef __EdBillboard_H__
#define __EdBillboard_H__

#include <config.h>
#include <osg/Billboard>
#include <editable/editableentity.h>
#include <editable/attributes/all.h>
#include <local.h>

class EdBillboard: public EditableEntity {
public:
    EdBillboard();
    EdBillboard(osg::Billboard *);
    virtual void setObject(osg::Object *object);
    virtual void commit();
    virtual EditableAttributeList getAttributes() { return list; }
    inline virtual std::string getName() const { return _("Billboard"); }
    inline virtual EditableEntity *clone() { return new EdBillboard(); }
    inline virtual void genObject() { setObject(new osg::Billboard()); }
    virtual osg::Object *getObject() { return model.get(); }
private:
    osg::ref_ptr< osg::Billboard > model;
    EditableAttributeList list;
    //Attributes
    osg::ref_ptr< EdEnum > mode;
    osg::ref_ptr< EdVec3 > axis;
    osg::ref_ptr< EdVec3 > normal;
};
#endif //__EdBillboard_H__
