#include "edbillboard.h"
#include <command/combillboard.h>

void EdBillboard::setObject(osg::Object *object) {
    model=dynamic_cast<osg::Billboard *> (object);
    if (model == 0) {
	std::cerr << "EdBillboard::setObject(): FATAL ERROR: This is not an 'osg::Billboard'" << std::endl;
	throw -1;
    }
    mode = new EdEnum( _("Rotation Mode"), _("Billboard rotation mode") );
    mode->addOption(_("POINT ROT EYE"),osg::Billboard::POINT_ROT_EYE);
    mode->addOption(_("POINT ROT WORLD"),osg::Billboard::POINT_ROT_WORLD);
    mode->addOption(_("AXIAL ROT"),osg::Billboard::AXIAL_ROT);
    mode->setInitial(model->getMode());

    list.push_back(mode.get());
    axis = new EdVec3( _("Rotation Axis"), _("Axis over which the billboard will rotate if mode is AXIAL ROT") );
    axis->setInitial(model->getAxis());

    list.push_back(axis.get());
    normal = new EdVec3( _("Normal"), _("Normal of billboard's drawable front face") );
    normal->setInitial(model->getNormal());

    list.push_back(normal.get());

}

EdBillboard::EdBillboard() {}

EdBillboard::EdBillboard(osg::Billboard *_model) {
    setObject(_model);
}

void EdBillboard::commit() {
    osg::ref_ptr<ComBillboard> com =
	new ComBillboard(model.get(), (osg::Billboard::Mode)mode->get(), axis->get(), normal->get());
    com->execute();
}
