#ifndef __EdAppConfig_H__
#define __EdAppConfig_H__

#include <config.h>
#include <appconfig.h>
#include <editable/editableentity.h>
#include <editable/attributes/all.h>
#include <local.h>

class EdAppConfig: public EditableEntity {
public:
    EdAppConfig();
    EdAppConfig(AppConfig *);
    virtual void setObject(osg::Object *object);
    virtual void commit();
    virtual EditableAttributeList getAttributes() { return list; }
    inline virtual std::string getName() const { return _("AppConfig"); }
    inline virtual EditableEntity *clone() { return new EdAppConfig(); }
    inline virtual void genObject() { throw -1; }
    inline virtual osg::Object *getObject() { return model.get(); }
private:
    osg::ref_ptr< AppConfig > model;
    EditableAttributeList list;
    //Attributes
    osg::ref_ptr< EdColour > grid_colour;
    osg::ref_ptr< EdReference > grid;
    osg::ref_ptr< EdReference > view;
};
#endif //__EdAppConfig_H__
