#include "edappconfig.h"
#include <editable/entityfactory.h>

void EdAppConfig::setObject(osg::Object *object) {
    model=dynamic_cast<AppConfig *> (object);
    if (model == 0) {
	std::cerr << "EdAppConfig::setObject(): FATAL ERROR: This is not an 'AppConfig'" << std::endl;
	throw -1;
    }
    grid_colour = new EdColour( _("Background colour"), _("Colour in the background of the 3D view") );
    grid_colour->setInitial(model->getBackgroundColor());

    list.push_back(grid_colour.get());
    grid = new EdReference( _("Grid"), _("Attributes of the grid") );
    grid->setInitial(EntityFactory::instance()->findEntity(model->getCfgGrid()));

    list.push_back(grid.get());
    view = new EdReference( _("View"), _("Attributes of the grid") );
    view->setInitial(EntityFactory::instance()->findEntity(model->getCfgView()));

    list.push_back(view.get());

}

EdAppConfig::EdAppConfig() {}

EdAppConfig::EdAppConfig(AppConfig *_model) {
    setObject(_model);
}

void EdAppConfig::commit() {
    if (grid_colour->hasChanged() == true) {
	model->setBackgroundColor(grid_colour->get());
    }
    if (grid->hasChanged() == true) {
        grid->get()->commit();
    }
    if (view->hasChanged() == true) {
        view->get()->commit();
    }
}
