#ifndef __EDITABLE_ENTITY_H__
#define __EDITABLE_ENTITY_H__

#include <osg/Object>
#include <string>
#include "editableattribute.h"

/** @class EditableEntity
 * @brief Editable class of OSG
 *
 * This is the interface that may follow all the wrappers that make OSG
 * classes editable.
 */
class EditableEntity: public osg::Referenced {
public:
    /** Commits all the changes in the OSG class creating and executing a
     * command */
    virtual std::string getName() const =0;

    /// Commits the changes, generating a command and executing it
    virtual void commit()=0;

    /// Sets the actual entity edited that is wrapped by this class
    virtual void setObject(osg::Object *object)=0;

    /// Returns the actual entity edited
    virtual osg::Object *getObject()=0;

    /// Generates a new entity to be edited that is wrapped by this class
    virtual void genObject()=0;

    /// Returns the list of attributes of this entity
    virtual EditableAttributeList getAttributes()=0;

    /// Prototype pattern
    virtual EditableEntity *clone()=0;
};

#endif //__EDITABLE_ENTITY_H__
