#ifndef __EDITABLE_ATTRIBUTE_H__
#define __EDITABLE_ATTRIBUTE_H__

#include <string>
#include <vector>
#include <osg/Referenced>
#include <osg/ref_ptr>

/** @class EditableAttribute
 * @brief Encapsulates one of the OSG class attributes that may be editable
 */
class EditableAttribute: public osg::Referenced {
public:
    class Observer: public osg::Referenced {
    public: virtual void attributeChanged(EditableAttribute *source)=0;
    };
public:
    EditableAttribute(std::string name, std::string description);

    /** Returns the name of the concrete attribute */
    inline std::string getName() const { return name; }

    /** Returns the description of the concrete attribute */
    inline std::string getDescription() const { return description; }

    /** Returns the type of this attribute */
    virtual std::string getType()=0;

    /** Checks if the attribute has changed */
    virtual bool hasChanged() const =0;

    virtual std::string toString() const = 0;

    void addObserver(Observer *obs);
    void removeObserver(Observer *obs);
protected:
    void notifyChange();
private:
    std::string name;
    std::string description;
    std::vector< Observer* > observers; // Not using reference to avoid cicles
};

typedef std::vector< osg::ref_ptr<EditableAttribute> > EditableAttributeList;

#endif //__EDITABLE_ATTRIBUTE_H__
